﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Net.Http;
using PostitCommon;
using PostitCore;
using DeXGets;
namespace DeX_Demo_Jun21
{
    class GetMyData
    {
        private HttpClient pHttpClient = null;
        private CallInfo pCallInfo = null;

        public GetMyData(CallInfo callInfo, ref HttpClient httpclient)
        {
            pHttpClient = httpclient;
            pCallInfo = callInfo;
        }

        Dictionary<Guid, BaseLookups> _Genders;
        Dictionary<Guid, BaseLookups> _DietaryNeeds;
        Dictionary<Guid, BaseLookups> _MealTypes;
        Dictionary<Guid, BaseLookups> _LocationTypes;
        Dictionary<Guid, BaseLookups> _EmailLocationTypes;
        Dictionary<Guid, BaseLookups> _Titles;
        Dictionary<Guid, ContactContactDetails.ContactDetails_Response> _ContactDetails;
        Dictionary<Guid, ContactContactBasics.ContactBasics_Response> _ContactBasics;
        Dictionary<Guid, LearnerIdentifiers.LearnerIdentifiers_Response> _LearnerIdentifiers;
        Dictionary<Guid, LearnerPersonals.LearnerPersonals_Response> _LearnerPersonals;
        Dictionary<Guid, LearnerDietarys.LearnerDietarys_Response> _LearnerDietarys;
        Dictionary<Guid, LearnerRegistrations.LearnerRegistrations_Response> _LearnerRegistrations;
        Dictionary<Guid, GroupDefinition.PastoralGroupDefintion_Response> _NVYears;
        Dictionary<Guid, GroupDefinition.PastoralGroupDefintion_Response> _PrimaryClasses;
        Dictionary<Guid, LearnerContactDetails.LearnerContactDetails_Response> _LearnerContactDetails;
        Dictionary<Guid, string> _NCYMap;
        private void Load()
        {
            string token = pCallInfo.bearerToken.Token;
            string key = pCallInfo.arq.OCP_APIM_Key;
            // Get the list of location types
            LearnerLocationTypeLookup cLocationType = new LearnerLocationTypeLookup();
            _LocationTypes = cLocationType.GetValues(token, key, pHttpClient);
            // Get the list of location types
            LearnerEmailLocationTypeLookup ceMailLocationType = new LearnerEmailLocationTypeLookup();
            _EmailLocationTypes = ceMailLocationType.GetValues(token, key, pHttpClient);

            LearnerDietaryLookup cDietaryLookup = new LearnerDietaryLookup();
            _DietaryNeeds = cDietaryLookup.GetValues(token, key, pHttpClient);

            // Get the List of Genders
            LearnerGenderLookup cGenders = new LearnerGenderLookup();
            _Genders = cGenders.GetValues(token, key, pHttpClient);
            // Get the List of Genders
            LearnerMealTypeLookup cMealTypes = new LearnerMealTypeLookup();
            _MealTypes = cMealTypes.GetValues(token, key, pHttpClient);

            // Get the list of titles
            LearnerTitlesLookup cTitles = new LearnerTitlesLookup();
            _Titles = cTitles.GetValues(token, key, pHttpClient);
            // Get the list of Contacts Details - who links to whom,emails, ...
            ContactContactDetails cContactDetails = new ContactContactDetails();
            _ContactDetails = cContactDetails.GetValues(token, key, pHttpClient);
            // Get the List of Contact Contact Basics (Name and genders)
            ContactContactBasics cContactBasics = new ContactContactBasics();
            _ContactBasics = cContactBasics.GetValues(token, key, pHttpClient);
            // Get the List of Current Learner Identifiers (Name,year and genders)
            LearnerIdentifiers cLearnerIdentifiers = new LearnerIdentifiers();
            _LearnerIdentifiers = cLearnerIdentifiers.GetValues(token, key, pHttpClient);
            // Get Learner Personals - DOB for us
            LearnerPersonals cLearnerPersonals = new LearnerPersonals();
            _LearnerPersonals = cLearnerPersonals.GetValues(token, key, pHttpClient);
            // Get the pupil dietary info.
            LearnerDietarys cLearnerDietarys = new LearnerDietarys();
            _LearnerDietarys = cLearnerDietarys.GetValues(token, key, pHttpClient);
            // get Adno and UPN
            LearnerRegistrations cLearnerRegistrations = new LearnerRegistrations();
            _LearnerRegistrations = cLearnerRegistrations.GetValues(token, key, pHttpClient);
            // Get NC Year definitions
            GroupDefinitionNCYears cNCYears = new GroupDefinitionNCYears();
            _NVYears = cNCYears.GetValues(token, key, pHttpClient);

            // Get the NCY Group Memberships
            _NCYMap = new Dictionary<Guid, string>();
            CurrentGroupMemberships cGM = new CurrentGroupMemberships();
            foreach (GroupDefinitionNCYears.PastoralGroupDefintion_Response nyc in _NVYears.Values)
            {
                Dictionary<Guid, CurrentGroupMemberships.CurrentGroupMemberships_Response> cygm
                    = cGM.GetValues(token, key, pHttpClient, nyc.ExternalID);
                foreach (CurrentGroupMemberships.CurrentGroupMemberships_Response m in cygm.Values)
                {
                    _NCYMap.Add(m.Member.ExternalID, nyc.ShortName);
                }
            }
            // Get Primary class definitions
            GroupDefinitionPrimaryClasses cPrimaryClasses = new GroupDefinitionPrimaryClasses();
            _PrimaryClasses = cPrimaryClasses.GetValues(token, key, pHttpClient);
            // Get the learner's contacts
            LearnerContactDetails cLearnerContactDetails = new LearnerContactDetails();
            _LearnerContactDetails = cLearnerContactDetails.GetValues(token, key, pHttpClient);

        }
        public void Run()
        {
            PostitCommon.Log.LogFile = @"c:\temp\logfile.txt";
            PostitCommon.CallInfo callInfo = new PostitCommon.CallInfo();
            Load();
            Build();
            Export();

        }
        public string PreHeader = "<?xml version=\"1.0\"?>";
        public string OuterTag = "<SuperStarReport-Enhanced>";
        public string OuterTagEnd = "</SuperStarReport-Enhanced>";
        public string HeaderSection = @"
  <RecordTypesToProcess>
    <RecordType>Pupil</RecordType>
  </RecordTypesToProcess>
  <ReportVersion>ESSDeX2021</ReportVersion>
";
        public void Export()
        {
            using (System.IO.StreamWriter sw = new System.IO.StreamWriter(@"c:\temp\cexp.xml"))
            {
                sw.WriteLine(PreHeader);
                sw.WriteLine(OuterTag);
                sw.WriteLine(HeaderSection);
                
                foreach (StudentRecord s in ExportStudentList.Values)
                {
                    sw.WriteLine(s.toXML());
                }
                sw.WriteLine(OuterTagEnd);

            }
        }
        /*
       
        Done - public string PreferredSurname;
        Done - public string PreferredForename;
        Done - public string LegalSurname;
        Done - public string LegalForename;
        Done - public string AdmissionNumber;
        Done - public string UPN;
        Done - public Nullable<DateTime> DateOfBirth;
        Done - public string free_meal;
        Done - public string Diet;
        Done - public string Gender;
        Done - public string CurrentPrimaryClass;
        DONE - public string CurriculumYear;
        Done - public Nullable<DateTime> free_meal_start;
        Done - public Nullable<DateTime> free_meal_end;
        Done - public string HouseNumber;
        Done - public string HouseName;
        Done - public string Apartment;
        Done - public string Street;
        Done - public string District;
        Done - public string Town;
        Done - public string AdministrativeArea;
        Done - public string Postcode;
        Done - public string FSMTransitionalProtection;
        NOT AVAILABLE - public string Meal; Concept doesn't seem to exist in SIMS 8
        // you can have a meal choice per day!
        Done - public string Salutation;
        Done - public List<Telephone> telephones;
        Done - public List<Contact> contacts;
        Done - public string email_address;
        Done - public string Weekly_meal_pattern;

         */
        public Dictionary<Guid, StudentRecord> ExportStudentList = new Dictionary<Guid, StudentRecord>();
        public Dictionary<Guid, Contact> ExportContactList = new Dictionary<Guid, Contact>();
        private void Build()
        {
            BuildContacts();
            BuildStudents();
        }
        private void BuildStudents()
        {
            foreach (LearnerIdentifiers.LearnerIdentifiers_Response id in _LearnerIdentifiers.Values)
            {
                // Only add current students - that's why we start with Learner Identifiers
                // filtered on 'Current'
                StudentRecord r = new StudentRecord();
                #region Add the learner identifier data
                r.PreferredForename = id.Forename;
                r.PreferredSurname = id.Surname;
                r.ExternalID = id.ExternalID;
                r.Gender = id.GenderCategory;
                r.CurrentPrimaryClass = id.CurrentPrimaryClass.Description;
                #endregion
                // Get the curriculum year
                r.CurriculumYear = GetNCYear(r.ExternalID);
                #region Now add learner reg info.
                LearnerRegistrations.LearnerRegistrations_Response lr = null;
                if (_LearnerRegistrations.TryGetValue(id.ExternalID, out lr))
                {
                    r.AdmissionNumber = lr.AdmissionNumber;
                    r.UPN = lr.UniquePupilNumber;
                }
                #endregion;
                #region Update Dietarys
                LearnerDietarys.LearnerDietarys_Response ldie = null;
                if (_LearnerDietarys.TryGetValue(id.ExternalID, out ldie))
                {
                    r.free_meal_start = null;
                    r.free_meal_end = null;
                    r.free_meal = "F";
                    foreach (LearnerDietarys.DateRange d in ldie.FreeMealEligibilityPeriods)
                    {
                        // Take the latest
                        if ((d.StartDate == null || d.StartDate <= DateTime.Today)
                            && (d.EndDate == null || d.EndDate >= DateTime.Today))
                        {
                            r.FSMTransitionalProtection = d.Protected == true ? "T" : "F";
                            r.free_meal_start = d.StartDate;
                            r.free_meal_end = d.EndDate;
                            r.free_meal = "T";
                        }
                    }
                    r.Weekly_meal_pattern = "";
                    if (ldie.MealPatterns != null)
                    {
                        string s = "";
                        foreach (LearnerDietarys.MealPattern d in ldie.MealPatterns)
                        {
                            // Take the latest
                            if ((d.StartDate == null || d.StartDate <= DateTime.Today)
                                && (d.EndDate == null || d.EndDate >= DateTime.Today))
                            {

                                foreach (LearnerDietarys.MealPatternDiningSession ds in d.MealPatternDiningSessions)
                                {
                                    if (s != "")
                                    {
                                        s = s + ",";
                                    }
                                    s +=   GetMealTypeDescription(ds.MealType.ExternalID) +"(" + DOWMap(ds.DayOfWeek)+")";
                                }
                                break; // One will do...
                            }
                        }
                        r.Weekly_meal_pattern = s;
                    }
                    r.Diet = "";
                    foreach (BaseLookups lu in ldie.DietaryNeeds)
                    {
                        if (r.Diet != "")
                        {
                            r.Diet += ",";
                        }
                        r.Diet += GetDietaryNeedsDescription(lu.ExternalID);
                        //if (lu != null && lu.Description != null)
                        //{
                        //    r.Diet += (lu.Description.Replace("\"", "'").Replace(",", ";"));
                        //}
                    }
                }
                #endregion
                #region Update from Learner Personals
                // Add In data from Learner Personal
                LearnerPersonals.LearnerPersonals_Response lp = null;
                if (_LearnerPersonals.TryGetValue(id.ExternalID, out lp))
                {
                    r.DateOfBirth = lp.DateOfBirth;
                    r.LegalForename = lp.LegalForename;
                    r.LegalSurname = lp.LegalSurame;
                }
                #endregion
                #region Learner Contact Contact Details
                LearnerContactDetails.LearnerContactDetails_Response lcd = null;
                if (_LearnerContactDetails.TryGetValue(id.ExternalID, out lcd))
                {
                    r.Salutation = lcd.ParentalSalutation;
                    // Address 
                    foreach (LearnerContactDetails.AddressRecords ar in lcd.Addresses)
                    {
                        if ((ar.StartDate == null || ar.StartDate <= DateTime.Today)
                            && (ar.EndDate == null || ar.EndDate >= DateTime.Today))
                        {
                            r.HouseName = ar.Address.BuildingName;
                            r.HouseNumber = ar.Address.BuildingNumber;
                            r.Apartment = ar.Address.Apartment;
                            r.District = ar.Address.District;
                            r.AdministrativeArea = ar.Address.AdministrativeArea;
                            r.Town = ar.Address.Town;
                            r.Postcode = ar.Address.Postcode;
                            r.Street = ar.Address.Street;
                            break; // Can only cope with one current address
                        }

                    }
                    // Phones
                    foreach (LearnerContactDetails.Telephone tel in lcd.Telephones)
                    {
                        if (tel.UseForAutomatedMessages == true)
                        {
                            Telephone t = new Telephone();

                            t.location = GetLocationTypeDescription(tel.LocationType.ExternalID);
                            t.telephone = tel.TelephoneNumber;
                            t.main = tel.IsFirstPointOfContact == true ? "T" : "F";
                            if (r.telephones == null)
                            {
                                r.telephones = new List<Telephone>();
                            }
                            r.telephones.Add(t);

                        }
                    }
                    //email - just one
                    foreach (LearnerContactDetails.Email e in lcd.Emails)
                    {
                        if (e.UseForAutomatedMessages == true)
                        {
                            r.email_address = e.EmailAddress;
                            break;  // Want one!
                        }

                    }
                    foreach (LearnerContactDetails.cLearnerContactRelationships lcr in lcd.LearnerContactRelationships)
                    {
                        ContactLinks cl = new ContactLinks();
                        cl.Priority = lcr.Priority;
                        Contact con = null;
                        if (ExportContactList.TryGetValue(lcr.LearnerContact.ExternalID, out con))
                        {
                            cl.contact = con;
                            if (r.contacts == null)
                            {
                                r.contacts = new List<ContactLinks>();
                            }
                            r.contacts.Add(cl);
                        }
                    }
                }
                #endregion
                ExportStudentList.Add(r.ExternalID, r);
            }
        }
        /*
        Done - public string email;
        Done - public string mobile;
        Done - public string telephone;
        Done - public string lastname;  
        Done - public string firstname;
        Done - public string Title;
        Done - public string Gender;
        Done - public string salutation;
        Done - public string workemail;
        PROBLEM - public string Priority;  This is a feature of a relationship and not a contact
        Done - public string HouseNumber;
        Done - public string HouseName;
        Done - public string Apartment;
        Done - public string Street;
        Done - public string District;
        Done - public string Town;
        Done - public string AdministrativeArea;
        Done - public string Postcode;
         */
        public void BuildContacts()
        {
            Contact c = new Contact();
            foreach (ContactContactBasics.ContactBasics_Response cbr in _ContactBasics.Values)
            {
                c.lastname = cbr.Surname;
                c.firstname = cbr.Forename;
                c.ExternalID = cbr.ExternalID;
                c.salutation = cbr.Salutation;
                c.Gender = GetGenderDescription(cbr.Gender.ExternalID);
                c.Title = "";
                if (cbr.Title != null)
                {
                    c.Title = GetTitleDescription(cbr.Title.ExternalID);
                }
                ContactContactDetails.ContactDetails_Response cdr = null;
                // We only play if they have links to kids
                if (_ContactDetails.TryGetValue(c.ExternalID, out cdr))
                {
                    // Address
                    foreach (ContactContactDetails.AddressRecords ar in cdr.Addresses)
                    {
                        // is it current?
                        if ((ar.StartDate == null || ar.StartDate <= DateTime.Today)
                            && (ar.EndDate == null || ar.EndDate >= DateTime.Today))
                        {
                            c.HouseName = ar.Address.BuildingName;
                            c.HouseNumber = ar.Address.BuildingNumber;
                            c.Apartment = ar.Address.Apartment;
                            c.District = ar.Address.District;
                            c.AdministrativeArea = ar.Address.AdministrativeArea;
                            c.Town = ar.Address.Town;
                            c.Postcode = ar.Address.Postcode;
                            c.Street = ar.Address.Street;
                            break;
                        }
                    }
                    // Phone Numbers
                    foreach (ContactContactDetails.Telephone t in cdr.Telephones)
                    {
                        if (t.UseForAutomatedMessages == true)
                        {
                            string lt = GetLocationTypeDescription(t.LocationType.ExternalID);
                            if (lt == "Mobile")
                            {
                                c.mobile = t.TelephoneNumber;
                            }
                            else
                            {
                                c.telephone = t.TelephoneNumber;
                            }
                        }
                    }
                    // email
                    foreach (ContactContactDetails.Email e in cdr.Emails)
                    {
                        if (e.UseForAutomatedMessages == true)
                        {
                            string lt = GetEmailLocationTypeDescription(e.LocationType.ExternalID);
                            if (lt == "Work")
                            {
                                c.workemail = e.EmailAddress;
                            }
                            else if (lt == "Home")
                            {
                                c.email = e.EmailAddress;
                            }
                            else
                            {
                                c.email = e.EmailAddress;
                            }
                        }
                    }
                    // Add the contact to the list
                    ExportContactList.Add(c.ExternalID, c);
                }
            }
        }
        /// <summary>
        /// Looks up the NC Year of the Learner
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string GetNCYear(Guid id)
        {
            string ncy = "";
            if (!_NCYMap.TryGetValue(id, out ncy))
            {
                ncy = ""; // Not found
            }
            return ncy;
        }
        /// <summary>
        /// Get email location description
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string GetEmailLocationTypeDescription(Guid id)
        {
            string rc = "";
            BaseLookups lu = null;
            if (id != null && _EmailLocationTypes.TryGetValue(id, out lu))
            {
                return lu.Description;
            }
            return rc;
        }
        /// <summary>
        /// returns Location Type Desc
        /// </summary>
        public string GetLocationTypeDescription(Guid id)
        {
            string rc = "";
            BaseLookups lu = null;
            if (id != null && _LocationTypes.TryGetValue(id, out lu))
            {
                return lu.Description;
            }
            return rc;
        }
        /// <summary>
        /// returns Location Type Desc
        /// </summary>
        public string GetDietaryNeedsDescription(Guid id)
        {
            string rc = "";
            BaseLookups lu = null;
            if (id != null && _DietaryNeeds.TryGetValue(id, out lu))
            {
                return lu.Description;
            }
            return rc;
        }
        /// <summary>
        /// returns Gender Desc
        /// </summary>
        public string GetGenderDescription(Guid id)
        {
            string rc = "";
            BaseLookups lu = null;
            if (id != null && _Genders.TryGetValue(id, out lu))
            {
                return lu.Description;
            }
            return rc;
        }
        /// <summary>
        /// Returns title
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string GetTitleDescription(Guid id)
        {
            string rc = "";
            BaseLookups lu = null;
            if (id != null && _Titles.TryGetValue(id, out lu))
            {
                return lu.Description;
            }
            return rc;
        }
        /// <summary>
        /// Get Learner Meal Type Lookup Description
        /// </summary>
        /// <param name="id"></param>
        /// <returns></returns>
        public string GetMealTypeDescription(Guid id)
        {
            string rc = "";
            BaseLookups lu = null;
            if (id != null && _MealTypes.TryGetValue(id, out lu))
            {
                return lu.Description;
            }
            return rc;
        }
        public string DOWMap(string dayNum)
        {
            string rc = "?";
            if (dayNum == "1")
            {
                rc = "Mon";
            }
            else if (dayNum == "2")
            {
                rc = "Tue";
            }
            if (dayNum == "3")
            {
                rc = "Wed";
            }
            if (dayNum == "4")
            {
                rc = "Thu";
            }
            if (dayNum == "5")
            {
                rc = "Fri";
            }
            if (dayNum == "6")
            {
                rc = "Sat";
            }
            if (dayNum == "0")
            {
                rc = "Sun";
            }
            return rc;
        }
    }
}